package com.ejie.ab04b.dao.solicitud;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.control.EstadosSolicitud;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Pais;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.model.solicitud.SolicDatosNotificacion;
import com.ejie.ab04b.model.solicitud.SolicOS3;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * Ab0461s01DaoImpl generated by UDA, 04-jul-2017 12:31:52.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class SolicOS3DaoImpl implements SolicOS3Dao {
	private static String QUERY_SELECT = "SELECT t1.ID_SOLICITUD_061 IDSOLICITUD061,t1.TEROS3_061 TEROS3061,t1.ANOOS3_061 ANOOS3061,t1.NUMOS3_061 NUMOS3061,t1.FECPRE_061 FECPRE061,"
			+ "t1.FECIER_061 FECIER061,t1.TERAPE_061 TERAPE061,t1.ANOAPE_061 ANOAPE061,t1.NUMAPE_061 NUMAPE061,"
			+ "t1.NUEVA_061 NUEVA061,t1.TIPDOC_061 TIPDOC061,t1.NUMDOC_061 NUMDOC061,t1.NOMEMP_061 NOMEMP061,t1.PAISEMP_061 PAISEMP061,t1.PRVEMP_061 PRVEMP061,"
			+ "t1.MUNEMP_061 MUNEMP061,t1.DMUNEMP_061 DMUNEMP061,t1.DIREMP_061 DIREMP061,t1.CPOEMP_061 CPOEMP061,t1.TLFEMP_061 TLFEMP061,t1.FAXEMP_061 FAXEMP061,"
			+ "t1.EMAEMP_061 EMAEMP061,t1.HTTPEMP_061 HTTPEMP061,t1.CLASCTR_061 CLASCTR061,t1.TRBTOT_061 TRBTOT061,t1.DECLAR_061 DECLAR061,t1.CARDEC_061 CARDEC061,"
			+ "t1.FECEVR_061 FECEVR061,t1.DESRIE_061 DESRIE061,t1.DESACT_061 DESACT061,t1.OBSERV_061 OBSERV061,t1.CODCTR_061 CODCTR061,t1.FECALT_061 FECALT061,t1.USUALT_061 USUALT061,"
			+ "t1.FECMOD_061 FECMOD061,t1.USUMOD_061 USUMOD061,t1.DESCEMP_061 DESCEMP061,t1.DOCCORRECTA_061 DOCCORRECTA061,t1.ESTADO_061 ESTADO061,t1.FORPRE_061 FORPRE061,"
			+ "t1.MIGRADO_061 MIGRADO061,t1.FOLDER_ID_061 FOLDERID061,t1.COD_DATOS_NOTIF_061 CODDATOSNOTIF061,t1.NUMDOCREPRESENTANTE_061 NUMDOCREPRESENTANTE061,"
			+ "t1.TLFREPRESENTANTE_061 TLFREPRESENTANTE061,t1.TIT_REPR_061 TITREPR061,t1.NOMREPRESENTANTE_061 NOMREPRESENTANTE061,t1.TIPDOCREPRESENTANTE_061 TIPDOCREPRESENTANTE061,"
			+ "t1.NUMREGISTRO_061 NUMREGISTRO061,t1.TIPOSOL_061 TIPOSOL061,t1.DESC_ESTADO_SOL_061 DESCESTADOSOLICITUD061,t1.ESTADO_SOLICITUD_061 ESTADOSOLICITUD061 ";

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<SolicOS3> rwMap = new RowMapper<SolicOS3>() {
		public SolicOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			return new SolicOS3(resultSet.getLong("IDSOLICITUD061"),
					resultSet.getString("TEROS3061"),
					resultSet.getString("ANOOS3061"),
					resultSet.getInt("NUMOS3061"),
					resultSet.getDate("FECPRE061"),
					resultSet.getDate("FECIER061"),
					resultSet.getString("TERAPE061"),
					resultSet.getString("ANOAPE061"),
					resultSet.getInt("NUMAPE061"),
					resultSet.getString("NUEVA061"),
					resultSet.getString("TIPDOC061"),
					resultSet.getString("NUMDOC061"),
					resultSet.getString("NOMEMP061"),
					new Pais(resultSet.getString("PAISEMP061")),
					new Provincia(resultSet.getString("PRVEMP061")),
					new Municipio(resultSet.getString("MUNEMP061")),
					resultSet.getString("DMUNEMP061"),
					resultSet.getString("DIREMP061"),
					resultSet.getString("CPOEMP061"),
					resultSet.getString("TLFEMP061"),
					resultSet.getString("FAXEMP061"),
					resultSet.getString("EMAEMP061"),
					resultSet.getString("HTTPEMP061"),
					resultSet.getString("CLASCTR061"),
					resultSet.getLong("TRBTOT061"),
					resultSet.getString("DECLAR061"),
					resultSet.getString("CARDEC061"),
					resultSet.getDate("FECEVR061"),
					resultSet.getString("DESRIE061"),
					resultSet.getString("DESACT061"),
					resultSet.getString("OBSERV061"),
					resultSet.getInt("CODCTR061"),
					resultSet.getDate("FECALT061"),
					resultSet.getString("USUALT061"),
					resultSet.getDate("FECMOD061"),
					resultSet.getString("USUMOD061"),
					resultSet.getString("DESCEMP061"),
					resultSet.getString("DOCCORRECTA061"),
					resultSet.getString("ESTADO061"),
					resultSet.getString("FORPRE061"),
					resultSet.getString("MIGRADO061"),
					resultSet.getString("FOLDERID061"),
					new SolicDatosNotificacion(
							resultSet.getInt("CODDATOSNOTIF061")),
					resultSet.getString("NUMDOCREPRESENTANTE061"),
					resultSet.getString("TLFREPRESENTANTE061"),
					resultSet.getString("TITREPR061"),
					resultSet.getString("NOMREPRESENTANTE061"),
					resultSet.getString("TIPDOCREPRESENTANTE061"),
					resultSet.getLong("TIPOSOL061"),
					resultSet.getString("ESTADOSOLICITUD061"),
					resultSet.getString("NUMREGISTRO061"),
					resultSet.getString("DESCESTADOSOLICITUD061"));

		}

	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 *
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Updates a single row in the Ab0461s01 table.
	 * 
	 * solicitud Ab0461s01 Ab0461s01
	 *
	 * @param solicitud
	 *            the solicitud
	 * @return the solic OS 3
	 */
	public SolicOS3 update(SolicOS3 solicitud) {
		String query = "UPDATE AB0461S01 SET "
				+ "TEROS3_061=?,ANOOS3_061=?,NUMOS3_061=?,FECPRE_061=?,FECIER_061=?,"
				+ "TERAPE_061=?,ANOAPE_061=?,NUMAPE_061=?,NUEVA_061=?,TIPDOC_061=?,NUMDOC_061=?,NOMEMP_061=?,PAISEMP_061=?,PRVEMP_061=?,"
				+ "MUNEMP_061=?,DMUNEMP_061=?,DIREMP_061=?,CPOEMP_061=?,TLFEMP_061=?,EMAEMP_061=?,FAXEMP_061=?,HTTPEMP_061=?,CLASCTR_061=?,"
				+ "TRBTOT_061=?,DECLAR_061=?,CARDEC_061=?,FECEVR_061=?,DESRIE_061=?,DESACT_061=?,OBSERV_061=?,CODCTR_061=?,FECALT_061=?,"
				+ "USUALT_061=?,FECMOD_061=?,USUMOD_061=?,DESCEMP_061=?,DOCCORRECTA_061=?,ESTADO_061=?,FORPRE_061=?,MIGRADO_061=?,"
				+ "FOLDER_ID_061=?,COD_DATOS_NOTIF_061=?,NUMDOCREPRESENTANTE_061=?,TLFREPRESENTANTE_061=?,TIT_REPR_061=?,"
				+ "NOMREPRESENTANTE_061=?,TIPDOCREPRESENTANTE_061=?,NUMREGISTRO_061=?,TIPOSOL_061=?,DESC_ESTADO_SOL_061=?,ESTADO_SOLICITUD_061=? "
				+ " WHERE ID_SOLICITUD_061=? ";

		this.jdbcTemplate.update(query,

				solicitud.getTeros3061(), solicitud.getAnoos3061(),
				solicitud.getNumos3061(), solicitud.getFecpre061(),
				solicitud.getFecier061(), solicitud.getTerape061(),
				solicitud.getAnoape061(), solicitud.getNumape061(),
				solicitud.getNueva061(), solicitud.getTipdoc061(),
				solicitud.getNumdoc061(), solicitud.getNomemp061(),
				(solicitud.getPaisemp061() == null ? ""
						: solicitud.getPaisemp061().getId()),
				(solicitud.getPrvemp061() == null ? ""
						: solicitud.getPrvemp061().getCodProvincia()),
				(solicitud.getMunemp061() == null ? ""
						: solicitud.getMunemp061().getCodMunicipio()),
				solicitud.getDmunemp061(), solicitud.getDiremp061(),
				solicitud.getCpoemp061(), solicitud.getTlfemp061(),
				solicitud.getFaxemp061(), solicitud.getEmaemp061(),
				solicitud.getHttpemp061(), solicitud.getClasctr061(),
				solicitud.getTrbtot061(),

				solicitud.getDeclar061(), solicitud.getCardec061(),
				solicitud.getFecevr061(), solicitud.getDesrie061(),
				solicitud.getDesact061(),

				solicitud.getObserv061(), solicitud.getCodctr061(),
				solicitud.getFecalt061(), solicitud.getUsualt061(),
				solicitud.getFecmod061(), solicitud.getUsumod061(),
				solicitud.getDescemp061(), solicitud.getDoccorrecta061(),
				solicitud.getEstado061(), solicitud.getForpre061(),
				solicitud.getMigrado061(), solicitud.getFolderid061(),
				(solicitud.getCodDatosNotif061() == null ? ""
						: solicitud.getCodDatosNotif061()
								.getCodDatosNotif066()),
				solicitud.getNumdocrepresentante061(),
				solicitud.getTlfrepresentante061(), solicitud.getTitRepr061(),
				solicitud.getNomrepresentante061(),
				solicitud.getTipdocrepresentante061(),
				solicitud.getNumRegistro061(), solicitud.getTiposol061(),
				solicitud.getDescEstadoSolicitud061(),
				solicitud.getEstadoSolicitud061(),

				solicitud.getIdSolicitud061());
		return solicitud;
	}

	/**
	 * Updates a single row in the SolicOS3 table.
	 * 
	 * solicitud SolicOS3 SolicOS3
	 *
	 * @param solicitud
	 *            the solicitud
	 * @return the solic OS 3
	 */
	public SolicOS3 updateFilled(SolicOS3 solicitud) {
		StringBuilder query = new StringBuilder("UPDATE AB0461S01 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (solicitud != null) {
			if (solicitud.getEstadoSolicitud061() != null) {
				queryFields.append(" ESTADO_SOLICITUD_061 = ? ");
				params.add(solicitud.getEstadoSolicitud061());
			}
			if (solicitud.getNumRegistro061() != null) {
				queryFields.append(", NUMREGISTRO_061 = ? ");
				params.add(solicitud.getNumRegistro061());
			}
			if (solicitud.getFecpre061() != null) {
				queryFields.append(", FECPRE_061 = ? ");
				params.add(solicitud.getFecpre061());
			}
			if (solicitud.getFolderid061() != null) {
				queryFields.append(", FOLDER_ID_061 = ? ");
				params.add(solicitud.getFolderid061());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}
		}

		query.append(queryFields);
		query.append(" WHERE ID_SOLICITUD_061 = ?");

		params.add(solicitud.getIdSolicitud061());

		this.jdbcTemplate.update(query.toString(), params.toArray());
		return solicitud;
	}

	/**
	 * Updates a single row in the Solicitudes table.
	 * 
	 * solicitudes Solicitudes Solicitudes
	 *
	 * @param solicitudes
	 *            the solicitudes
	 * @return the solic OS 3
	 */
	public SolicOS3 updateDatosOs(SolicOS3 solicitudes) {
		String query = "UPDATE AB0461S01 SET ANOOS3_061 = ?, NUMOS3_061= ?, TEROS3_061= ? WHERE ID_SOLICITUD_061 = ? ";
		this.jdbcTemplate.update(query, solicitudes.getAnoos3061(),
				solicitudes.getNumos3061(), solicitudes.getTeros3061(),
				solicitudes.getIdSolicitud061());
		return solicitudes;
	}

	/**
	 * Finds a single row in the Ab0461s01 table.
	 * 
	 * solicitud Ab0461s01 Ab0461s01
	 *
	 * @param solicitud
	 *            the solicitud
	 * @return the solic OS 3
	 */
	@Transactional(readOnly = true)
	public SolicOS3 find(SolicOS3 solicitud) {
		StringBuilder query = new StringBuilder(QUERY_SELECT);
		query.append(" FROM AB0461S01 t1 ");
		query.append(" WHERE t1.ID_SOLICITUD_061 = ? ");

		List<SolicOS3> solicos3List = this.jdbcTemplate.query(query.toString(),
				this.rwMap, solicitud.getIdSolicitud061());
		return (SolicOS3) DataAccessUtils.uniqueResult(solicos3List);
	}

	/**
	 * Removes a single row in the Ab0461s01 table.
	 * 
	 * solicitud Ab0461s01
	 *
	 * @param solicitud
	 *            the solicitud
	 */
	public void remove(SolicOS3 solicitud) {
		String query = "DELETE FROM AB0461S01 WHERE ID_SOLICITUD_061=? ";
		this.jdbcTemplate.update(query, solicitud.getIdSolicitud061());
	}

	/**
	 * Finds a list of rows in the Ab0461s01 table.
	 * 
	 * solicitud Ab0461s01 jqGridRequestDto JQGridRequestDto List<Ab0461s01>
	 *
	 * @param solicitud
	 *            the solicitud
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<SolicOS3> findAll(SolicOS3 solicitud,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(QUERY_SELECT);
		query.append(" FROM AB0461S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(solicitud);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<SolicOS3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0461s01 table using like.
	 * 
	 * solicitud Ab0461s01 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0461s01>
	 *
	 * @param solicitud
	 *            the solicitud
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<SolicOS3> findAllLike(SolicOS3 solicitud,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(QUERY_SELECT);
		query.append(" FROM AB0461S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(solicitud, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<SolicOS3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0461s01 table.
	 * 
	 * solicitud Ab0461s01 Long
	 *
	 * @param solicitud
	 *            the solicitud
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(SolicOS3 solicitud) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0461S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(solicitud);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0461s01 table using like.
	 * 
	 * solicitud Ab0461s01 startsWith Boolean Long
	 *
	 * @param solicitud
	 *            the solicitud
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(SolicOS3 solicitud, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0461S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(solicitud, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a list of rows in the SolicOS3 table.
	 * 
	 * List<SolicOS3>
	 *
	 * @param nif
	 *            the nif
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<SolicOS3> findAllBorradoresUsuario(String nif,
			JQGridRequestDto jqGridRequestDto) {

		StringBuilder query = new StringBuilder(SolicOS3DaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ESTADO_SOLICITUD_061 in (?) ");
		query.append(
				" AND ((TIT_REPR_061 = ? AND NUMDOC_061 = ?) OR (TIT_REPR_061 = ? AND NUMDOCREPRESENTANTE_061 = ?)) ");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		List<Object> params = new ArrayList<Object>();
		params.add((EstadosSolicitud.BORRADOR.name() + ","
				+ EstadosSolicitud.PLANTILLA.name()));
		params.add(Constantes.SOLICITANTE_TITULAR);
		params.add(nif);
		params.add(Constantes.SOLICITANTE_REPRESENTANTE);
		params.add(nif);

		return (List<SolicOS3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0461s01 entity
	 * 
	 * solicitud Ab0461s01 Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 *
	 * @param solicitud
	 *            the solicitud
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(SolicOS3 solicitud) {

		StringBuilder where = new StringBuilder(
				SolicOS3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (solicitud != null && solicitud.getIdSolicitud061() != null) {
			where.append(" AND t1.ID_SOLICITUD_061 = ?");
			params.add(solicitud.getIdSolicitud061());
		}
		if (solicitud != null && solicitud.getTeros3061() != null) {
			where.append(" AND t1.TEROS3_061 = ?");
			params.add(solicitud.getTeros3061());
		}
		if (solicitud != null && solicitud.getAnoos3061() != null) {
			where.append(" AND t1.ANOOS3_061 = ?");
			params.add(solicitud.getAnoos3061());
		}
		if (solicitud != null && solicitud.getNumos3061() != null) {
			where.append(" AND t1.NUMOS3_061 = ?");
			params.add(solicitud.getNumos3061());
		}
		if (solicitud != null && solicitud.getFecpre061() != null) {
			where.append(" AND t1.FECPRE_061 = ?");
			params.add(solicitud.getFecpre061());
		}
		if (solicitud != null && solicitud.getFecier061() != null) {
			where.append(" AND t1.FECIER_061 = ?");
			params.add(solicitud.getFecier061());
		}
		if (solicitud != null && solicitud.getTerape061() != null) {
			where.append(" AND t1.TERAPE_061 = ?");
			params.add(solicitud.getTerape061());
		}
		if (solicitud != null && solicitud.getAnoape061() != null) {
			where.append(" AND t1.ANOAPE_061 = ?");
			params.add(solicitud.getAnoape061());
		}
		if (solicitud != null && solicitud.getNumape061() != null) {
			where.append(" AND t1.NUMAPE_061 = ?");
			params.add(solicitud.getNumape061());
		}
		if (solicitud != null && solicitud.getTipdoc061() != null) {
			where.append(" AND t1.TIPDOC_061 = ?");
			params.add(solicitud.getTipdoc061());
		}
		if (solicitud != null && solicitud.getNumdoc061() != null) {
			where.append(" AND t1.NUMDOC_061 = ?");
			params.add(solicitud.getNumdoc061());
		}
		if (solicitud != null && solicitud.getNomemp061() != null) {
			where.append(" AND t1.NOMEMP_061 = ?");
			params.add(solicitud.getNomemp061());
		}
		if (solicitud != null && solicitud.getPrvemp061() != null) {
			where.append(" AND t1.PRVEMP_061 = ?");
			params.add(solicitud.getPrvemp061());
		}
		if (solicitud != null && solicitud.getMunemp061() != null) {
			where.append(" AND t1.MUNEMP_061 = ?");
			params.add(solicitud.getMunemp061());
		}
		if (solicitud != null && solicitud.getDiremp061() != null) {
			where.append(" AND t1.DIREMP_061 = ?");
			params.add(solicitud.getDiremp061());
		}
		if (solicitud != null && solicitud.getCpoemp061() != null) {
			where.append(" AND t1.CPOEMP_061 = ?");
			params.add(solicitud.getCpoemp061());
		}
		if (solicitud != null && solicitud.getTlfemp061() != null) {
			where.append(" AND t1.TLFEMP_061 = ?");
			params.add(solicitud.getTlfemp061());
		}
		if (solicitud != null && solicitud.getFaxemp061() != null) {
			where.append(" AND t1.FAXEMP_061 = ?");
			params.add(solicitud.getFaxemp061());
		}
		if (solicitud != null && solicitud.getEmaemp061() != null) {
			where.append(" AND t1.EMAEMP_061 = ?");
			params.add(solicitud.getEmaemp061());
		}
		if (solicitud != null && solicitud.getHttpemp061() != null) {
			where.append(" AND t1.HTTPEMP_061 = ?");
			params.add(solicitud.getHttpemp061());
		}

		if (solicitud != null && solicitud.getObserv061() != null) {
			where.append(" AND t1.OBSERV_061 = ?");
			params.add(solicitud.getObserv061());
		}
		if (solicitud != null && solicitud.getCodctr061() != null) {
			where.append(" AND t1.CODCTR_061 = ?");
			params.add(solicitud.getCodctr061());
		}
		if (solicitud != null && solicitud.getFecalt061() != null) {
			where.append(" AND t1.FECALT_061 = ?");
			params.add(solicitud.getFecalt061());
		}
		if (solicitud != null && solicitud.getUsualt061() != null) {
			where.append(" AND t1.USUALT_061 = ?");
			params.add(solicitud.getUsualt061());
		}
		if (solicitud != null && solicitud.getFecmod061() != null) {
			where.append(" AND t1.FECMOD_061 = ?");
			params.add(solicitud.getFecmod061());
		}
		if (solicitud != null && solicitud.getUsumod061() != null) {
			where.append(" AND t1.USUMOD_061 = ?");
			params.add(solicitud.getUsumod061());
		}
		if (solicitud != null && solicitud.getDmunemp061() != null) {
			where.append(" AND t1.DMUNEMP_061 = ?");
			params.add(solicitud.getDmunemp061());
		}
		if (solicitud != null && solicitud.getDescemp061() != null) {
			where.append(" AND t1.DESCEMP_061 = ?");
			params.add(solicitud.getDescemp061());
		}

		if (solicitud != null && solicitud.getPaisemp061() != null) {
			where.append(" AND t1.PAISEMP_061 = ?");
			params.add(solicitud.getPaisemp061());
		}
		if (solicitud != null && solicitud.getDoccorrecta061() != null) {
			where.append(" AND t1.DOCCORRECTA_061 = ?");
			params.add(solicitud.getDoccorrecta061());
		}

		if (solicitud != null && solicitud.getEstado061() != null) {
			where.append(" AND t1.ESTADO_061 = ?");
			params.add(solicitud.getEstado061());
		}
		if (solicitud != null && solicitud.getForpre061() != null) {
			where.append(" AND t1.FORPRE_061 = ?");
			params.add(solicitud.getForpre061());
		}
		if (solicitud != null && solicitud.getMigrado061() != null) {
			where.append(" AND t1.MIGRADO_061 = ?");
			params.add(solicitud.getMigrado061());
		}
		if (solicitud != null && solicitud.getFolderid061() != null) {
			where.append(" AND t1.FOLDER_ID_061 = ?");
			params.add(solicitud.getFolderid061());
		}
		if (solicitud != null && solicitud.getCodDatosNotif061() != null) {
			where.append(" AND t1.COD_DATOS_NOTIF_061 = ?");
			params.add(solicitud.getCodDatosNotif061());
		}
		if (solicitud != null
				&& solicitud.getNumdocrepresentante061() != null) {
			where.append(" AND t1.NUMDOCREPRESENTANTE_061 = ?");
			params.add(solicitud.getNumdocrepresentante061());
		}
		if (solicitud != null && solicitud.getTlfrepresentante061() != null) {
			where.append(" AND t1.TLFREPRESENTANTE_061 = ?");
			params.add(solicitud.getTlfrepresentante061());
		}
		if (solicitud != null && solicitud.getTitRepr061() != null) {
			where.append(" AND t1.TIT_REPR_061 = ?");
			params.add(solicitud.getTitRepr061());
		}
		if (solicitud != null && solicitud.getNomrepresentante061() != null) {
			where.append(" AND t1.NOMREPRESENTANTE_061 = ?");
			params.add(solicitud.getNomrepresentante061());
		}
		if (solicitud != null
				&& solicitud.getTipdocrepresentante061() != null) {
			where.append(" AND t1.TIPDOCREPRESENTANTE_061 = ?");
			params.add(solicitud.getTipdocrepresentante061());
		}
		if (solicitud != null && solicitud.getTiposol061() != null) {
			where.append(" AND t1.TIPOSOL_061 = ?");
			params.add(solicitud.getTiposol061());
		}
		if (solicitud != null && solicitud.getNumRegistro061() != null) {
			where.append(" AND t1.NUMREGISTRO_061 = ?");
			params.add(solicitud.getNumRegistro061());
		}

		if (solicitud != null && solicitud.isFiltroBorradoresUsuario()) {
			where.append(" AND t1.ESTADO_SOLICITUD_061 in (?,?) ");
			where.append(
					" AND ((TIT_REPR_061 = ? AND NUMDOC_061 = ?) OR (TIT_REPR_061 = ? AND NUMDOCREPRESENTANTE_061 = ?)) ");

			params.add(EstadosSolicitud.BORRADOR.name());
			params.add(EstadosSolicitud.PLANTILLA.name());
			params.add(Constantes.SOLICITANTE_TITULAR);
			params.add(solicitud.getFiltroNifUsuario());
			params.add(Constantes.SOLICITANTE_REPRESENTANTE);
			params.add(solicitud.getFiltroNifUsuario());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0461s01 entity
	 * 
	 * solicitud Ab0461s01 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 *
	 * @param solicitud
	 *            the solicitud
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(SolicOS3 solicitud,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SolicOS3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (solicitud != null && solicitud.getIdSolicitud061() != null) {
			where.append(" AND t1.ID_SOLICITUD_061 = ?");
			params.add(solicitud.getIdSolicitud061());
		}
		if (solicitud != null && solicitud.getTeros3061() != null) {
			where.append(" AND UPPER(t1.TEROS3_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getTeros3061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getTeros3061().toUpperCase() + "%");
			}
			where.append(" AND t1.TEROS3_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getAnoos3061() != null) {
			where.append(" AND UPPER(t1.ANOOS3_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getAnoos3061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getAnoos3061().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOOS3_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getNumos3061() != null) {
			where.append(" AND t1.NUMOS3_061 = ?");
			params.add(solicitud.getNumos3061());
		}
		if (solicitud != null && solicitud.getFecpre061() != null) {
			where.append(" AND t1.FECPRE_061 = ?");
			params.add(solicitud.getFecpre061());
		}
		if (solicitud != null && solicitud.getFecier061() != null) {
			where.append(" AND t1.FECIER_061 = ?");
			params.add(solicitud.getFecier061());
		}
		if (solicitud != null && solicitud.getTerape061() != null) {
			where.append(" AND UPPER(t1.TERAPE_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getTerape061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getTerape061().toUpperCase() + "%");
			}
			where.append(" AND t1.TERAPE_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getAnoape061() != null) {
			where.append(" AND UPPER(t1.ANOAPE_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getAnoape061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getAnoape061().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOAPE_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getNumape061() != null) {
			where.append(" AND t1.NUMAPE_061 = ?");
			params.add(solicitud.getNumape061());
		}
		if (solicitud != null && solicitud.getTipdoc061() != null) {
			where.append(" AND UPPER(t1.TIPDOC_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getTipdoc061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getTipdoc061().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPDOC_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getNumdoc061() != null) {
			where.append(" AND UPPER(t1.NUMDOC_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getNumdoc061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getNumdoc061().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMDOC_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getNomemp061() != null) {
			where.append(" AND UPPER(t1.NOMEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getNomemp061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getNomemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMEMP_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getPrvemp061() != null) {
			where.append(" AND UPPER(t1.PRVEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						solicitud.getPrvemp061().getCodProvincia().toUpperCase()
								+ "%");
			} else {
				params.add("%" + solicitud.getPrvemp061().getCodProvincia()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.PRVEMP_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getMunemp061() != null) {
			where.append(" AND UPPER(t1.MUNEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						solicitud.getMunemp061().getCodMunicipio().toUpperCase()
								+ "%");
			} else {
				params.add("%" + solicitud.getMunemp061().getCodMunicipio()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.MUNEMP_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getDiremp061() != null) {
			where.append(" AND UPPER(t1.DIREMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getDiremp061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getDiremp061().toUpperCase() + "%");
			}
			where.append(" AND t1.DIREMP_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getCpoemp061() != null) {
			where.append(" AND UPPER(t1.CPOEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getCpoemp061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getCpoemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.CPOEMP_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getTlfemp061() != null) {
			where.append(" AND UPPER(t1.TLFEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getTlfemp061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getTlfemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.TLFEMP_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getFaxemp061() != null) {
			where.append(" AND UPPER(t1.FAXEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getFaxemp061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getFaxemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.FAXEMP_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEmaemp061() != null) {
			where.append(" AND UPPER(t1.EMAEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEmaemp061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getEmaemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAEMP_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getHttpemp061() != null) {
			where.append(" AND UPPER(t1.HTTPEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getHttpemp061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getHttpemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.HTTPEMP_061 IS NOT NULL");
		}

		if (solicitud != null && solicitud.getTrbtot061() != null) {
			where.append(" AND t1.TRBTOT_061 = ?");
			params.add(solicitud.getTrbtot061());
		}

		if (solicitud != null && solicitud.getObserv061() != null) {
			where.append(" AND UPPER(t1.OBSERV_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getObserv061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getObserv061().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERV_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getCodctr061() != null) {
			where.append(" AND t1.CODCTR_061 = ?");
			params.add(solicitud.getCodctr061());
		}
		if (solicitud != null && solicitud.getFecalt061() != null) {
			where.append(" AND t1.FECALT_061 = ?");
			params.add(solicitud.getFecalt061());
		}
		if (solicitud != null && solicitud.getUsualt061() != null) {
			where.append(" AND UPPER(t1.USUALT_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getUsualt061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getUsualt061().toUpperCase() + "%");
			}
			where.append(" AND t1.USUALT_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getFecmod061() != null) {
			where.append(" AND t1.FECMOD_061 = ?");
			params.add(solicitud.getFecmod061());
		}
		if (solicitud != null && solicitud.getUsumod061() != null) {
			where.append(" AND UPPER(t1.USUMOD_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getUsumod061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getUsumod061().toUpperCase() + "%");
			}
			where.append(" AND t1.USUMOD_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getDmunemp061() != null) {
			where.append(" AND UPPER(t1.DMUNEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getDmunemp061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getDmunemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.DMUNEMP_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getDescemp061() != null) {
			where.append(" AND UPPER(t1.DESCEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getDescemp061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getDescemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCEMP_061 IS NOT NULL");
		}

		if (solicitud != null && solicitud.getPaisemp061() != null) {
			where.append(" AND UPPER(t1.PAISEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						solicitud.getPaisemp061().getId().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getPaisemp061().getId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PAISEMP_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getDoccorrecta061() != null) {
			where.append(" AND UPPER(t1.DOCCORRECTA_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getDoccorrecta061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getDoccorrecta061().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DOCCORRECTA_061 IS NOT NULL");
		}

		if (solicitud != null && solicitud.getEstado061() != null) {
			where.append(" AND UPPER(t1.ESTADO_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEstado061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getEstado061().toUpperCase() + "%");
			}
			where.append(" AND t1.ESTADO_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getForpre061() != null) {
			where.append(" AND UPPER(t1.FORPRE_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getForpre061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getForpre061().toUpperCase() + "%");
			}
			where.append(" AND t1.FORPRE_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getMigrado061() != null) {
			where.append(" AND UPPER(t1.MIGRADO_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getMigrado061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getMigrado061().toUpperCase() + "%");
			}
			where.append(" AND t1.MIGRADO_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getFolderid061() != null) {
			where.append(" AND UPPER(t1.FOLDER_ID_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getFolderid061().toUpperCase() + "%");
			} else {
				params.add(
						"%" + solicitud.getFolderid061().toUpperCase() + "%");
			}
			where.append(" AND t1.FOLDER_ID_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getCodDatosNotif061() != null) {
			where.append(" AND t1.COD_DATOS_NOTIF_061 = ?");
			params.add(solicitud.getCodDatosNotif061());
		}
		if (solicitud != null
				&& solicitud.getNumdocrepresentante061() != null) {
			where.append(
					" AND UPPER(t1.NUMDOCREPRESENTANTE_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getNumdocrepresentante061().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getNumdocrepresentante061().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NUMDOCREPRESENTANTE_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getTlfrepresentante061() != null) {
			where.append(
					" AND UPPER(t1.TLFREPRESENTANTE_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						solicitud.getTlfrepresentante061().toUpperCase() + "%");
			} else {
				params.add(
						"%" + solicitud.getTlfrepresentante061().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.TLFREPRESENTANTE_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getTitRepr061() != null) {
			where.append(" AND UPPER(t1.TIT_REPR_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getTitRepr061().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getTitRepr061().toUpperCase() + "%");
			}
			where.append(" AND t1.TIT_REPR_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getNomrepresentante061() != null) {
			where.append(
					" AND UPPER(t1.NOMREPRESENTANTE_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						solicitud.getNomrepresentante061().toUpperCase() + "%");
			} else {
				params.add(
						"%" + solicitud.getNomrepresentante061().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.NOMREPRESENTANTE_061 IS NOT NULL");
		}
		if (solicitud != null
				&& solicitud.getTipdocrepresentante061() != null) {
			where.append(
					" AND UPPER(t1.TIPDOCREPRESENTANTE_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getTipdocrepresentante061().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getTipdocrepresentante061().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TIPDOCREPRESENTANTE_061 IS NOT NULL");
		}
		if (solicitud != null && solicitud.getTiposol061() != null) {
			where.append(" AND t1.TIPOSOL_061 = ?");
			params.add(solicitud.getTiposol061());
		}
		if (solicitud != null && solicitud.getNumRegistro061() != null) {
			where.append(" AND t1.NUMREGISTRO_061 = ?");
			params.add(solicitud.getNumRegistro061());
		}

		if (solicitud != null && solicitud.isFiltroBorradoresUsuario()) {
			where.append(" AND t1.ESTADO_SOLICITUD_061 in (?,?) ");
			where.append(
					" AND ((TIT_REPR_061 = ? AND NUMDOC_061 = ?) OR (TIT_REPR_061 = ? AND NUMDOCREPRESENTANTE_061 = ?)) ");

			params.add(EstadosSolicitud.BORRADOR.name());
			params.add(EstadosSolicitud.PLANTILLA.name());
			params.add(Constantes.SOLICITANTE_TITULAR);
			params.add(solicitud.getFiltroNifUsuario());
			params.add(Constantes.SOLICITANTE_REPRESENTANTE);
			params.add(solicitud.getFiltroNifUsuario());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a single row in the SolicOS3 table.
	 * 
	 * numRegSolicitud String SolicOS3
	 *
	 * @param numRegSolicitud
	 *            the num reg solicitud
	 * @return the solic OS 3
	 */
	@Transactional(readOnly = true)
	public SolicOS3 findSolicitud(String numRegSolicitud) {
		StringBuilder query = new StringBuilder(SolicOS3DaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.NUMREGISTRO_061 = ? ");

		List<SolicOS3> SolicOS3List = this.jdbcTemplate.query(query.toString(),
				this.rwMap, numRegSolicitud);
		return (SolicOS3) DataAccessUtils.uniqueResult(SolicOS3List);
	}

	/**
	 * Updates a single row in the Solicitudes table.
	 * 
	 * solicitudes Solicitudes Solicitudes
	 *
	 * @param solicitudes
	 *            the solicitudes
	 * @return the solic OS 3
	 */
	public SolicOS3 updateDatosApe(SolicOS3 solicitudes) {
		String query = "UPDATE AB0461S01 SET ANOOS3061 = ?, NUMOS3061= ?, TEROS3061= ? WHERE ID_SOLICITUD_061 = ? ";
		this.jdbcTemplate.update(query, solicitudes.getAnoape061(),
				solicitudes.getNumape061(), solicitudes.getTerape061(),
				solicitudes.getIdSolicitud061());
		return solicitudes;
	}

	/**
	 * Updates a single row in the Solicitudes table.
	 * 
	 * solicitudes Solicitudes Solicitudes
	 *
	 * @param solicitudes
	 *            the solicitudes
	 * @return the solic OS 3
	 */
	public SolicOS3 updateEstado(SolicOS3 solicitudes) {
		String query = "UPDATE AB0461S01 SET ESTADO_SOLICITUD_061 = ? WHERE ID_SOLICITUD_061 = ? ";
		this.jdbcTemplate.update(query, solicitudes.getEstadoSolicitud061(),
				solicitudes.getIdSolicitud061());
		return solicitudes;
	}

}
